﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//	Summary
// 		* Audio manager.

namespace GameUtility
{
	/*
		Audio 관리자.
 	*/
	public class AudioManager : MonoBehaviour
	{

		public AudioClip m_ButtonClickClip;

		static GameObject _fakeObj;

		// Use this for initialization
		void Start ()
		{

		}
	
		// Update is called once per frame
		void Update ()
		{
		
		}

		/*
			Button click audio play.
		*/
		public void onPlayButtonClick ()
		{
			GetFakeObject ();
			AudioSource audioSource = _fakeObj.GetComponent<AudioSource> ();

			if (audioSource != null
			   && m_ButtonClickClip != null) {
				audioSource.clip = m_ButtonClickClip;
				audioSource.Play ();
			} else {
				Debug.LogError (audioSource + "And" + m_ButtonClickClip);
			}
		}

		/*
			Fake object.
	 	*/
		GameObject GetFakeObject ()
		{
			if (_fakeObj == null) {
				_fakeObj	= GameObject.FindWithTag ("Audio");

				if (_fakeObj == null) {
					GameObject obj = new GameObject ();
					obj.tag	= "Audio";
					obj.AddComponent<AudioSource> ();
					DontDestroyOnLoad (obj);

					_fakeObj	= obj;
				}
			}

			return _fakeObj;
		}
	}
}
